//
//  FileHandling.h
//  DsUltilities
//
//  Created by Dirk Stichling on 15.02.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/MyCocoa.h>

@interface FileWithDate : NSObject
{
    NSString* filename;
    NSDate* modificationDate;
    NSMutableDictionary* appGroupFolders;
}

@property (retain, atomic) NSString* filename;
@property (retain, atomic) NSDate* modificationDate;

@end

@interface FileHandling : NSObject {
    NSString* _userApplicationSupport;
    NSString* _userApplicationSupportTemp;
    NSString* _userImageCache;
    NSString* _customStyles;
    NSString* _userLocationCache;
    NSString* _resourcesPath;
    NSString* _library;
    NSString* _sandbox;
    NSMutableDictionary* _appGroupFolders;
}

+ (FileHandling*) singleton;

- (id) initWithLibrary:(NSString*)library bundleIdentifier:(NSString*)bundleIdentifier;

- (NSString*) userApplicationSupport;
- (NSString*) userApplicationSupportTemp;
- (NSString*) library;
- (NSString*) customStyles;

- (NSString*) userImageCache;
- (NSString*) writableImageCache;

- (NSString*) writableLocationCache;

- (NSString*) sandbox;

- (void) createFilesForCache:(NSString*)cache;
- (void) cleanup;

+ (NSString*) filenameForShell:(NSString*)filename;
+ (NSString*) stringForShell:(NSString*)filename;
+ (NSString*) filenameWithoutSpecialCharacters:(NSString*)filename;

+ (NSInteger) folderSize:(NSString*)path;
+ (void) deleteOldestFiles:(NSString*)path count:(NSInteger)count;
+ (void) deleteFilesAtPath:(NSString*)path;
+ (void) deleteFilesAndFolderAtPath:(NSString*)path;

+ (void) touch:(NSString*)path;

+ (NSString*) removeIllegalFilenameCharacters:(NSString*)filename;
+ (NSString*) removeIllegalFilenameCharactersFromLastPathComponent:(NSString*)filename;

- (NSURL*) getAppGroupUrlForFolder:(NSString*)folder;
- (NSString*) getAppGroupPathForFolder:(NSString*)folder;

+ (NSString*) resolveAlias:(NSString*)path;

NSInteger compareFileWithDate(FileWithDate* obj1, FileWithDate* obj2, void* data);

@end
