//
//  WayPointGPXElement.h
//  myTracks
//
//  Created by Dirk Stichling on 12.02.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class TrackPoint;

@interface WayPointGPXElement : NSObject <NSXMLParserDelegate>
{
    TrackPoint*                     _trackPoint;

    NSXMLParser*            _parser;
    id _parserParent;

    BOOL _parserInTime;
    BOOL _parserInElevation;
    
    NSMutableString*        _foundCharacters;
}

- (id) initForTrackPoint:(TrackPoint*)trackPoint parser:(NSXMLParser*)parser parent:(id)parserParent attributes:(NSDictionary*)attributeDict;
+ (WayPointGPXElement*) wayPointGPXElementForTrackPoint:(TrackPoint*)trackPoint parser:(NSXMLParser*)parser parent:(id)parserParent attributes:(NSDictionary*)attributeDict;

- (TrackPoint*)         trackPoint;

@end
