//
//  TrackPointGPXElement.h
//  myTracks
//
//  Created by Dirk Stichling on 10.02.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class TrackPoint;
@class TrackPhoto;

@interface TrackPointGPXElement : NSObject <NSXMLParserDelegate>
{
    TrackPoint*                     _trackPoint;
    TrackPhoto*         _trackPhoto;

    NSXMLParser*            _parser;
    id _parserParent;

    BOOL _parserInTime;
    BOOL _parserInElevation;
    BOOL _parserInSpeed;
    BOOL _parserInLength;
    BOOL _parserInName;
    BOOL _parserInPhoto;
    BOOL _parserInColor;
    BOOL _parserInSymbol;
    BOOL _parserInPhotoBookmark;

    BOOL _isRoute;

    NSMutableString*        _foundCharacters;
}

- (id) initForTrackPoint:(TrackPoint*)trackPoint parser:(NSXMLParser*)parser parent:(id)parserParent;
+ (TrackPointGPXElement*) trackPointGPXElementForTrackPoint:(TrackPoint*)trackPoint parser:(NSXMLParser*)parser parent:(id)parserParent;

@end
