//
//  TrackPhoto.h
//  myTracks
//
//  Created by Dirk Stichling on 08.03.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class ISODate;
@class TrackKMLConfiguration;

#import <DsTrackFramework/TrackPoint.h> // for enum TrackPointType

@interface TrackPhoto : NSObject {
    ISODate*_timeOfPhoto;

    NSImage*_image;
    NSString*_base64bookmark;
    NSURL*_securityScopeURL;
    BOOL _securityScopeURLStarted;

    NSString*_filepath;
    TrackPoint*_trackPoint;

    NSString*_city;
    NSString*_state;
    NSString*_country;
    NSString*_isoCountryCode;
    NSString*_place;

    NSString*_iCloudId;
}

@property (retain, atomic) NSString*iPhoneFilename;
@property (retain, atomic) NSString*iCloudId;

@property (retain, atomic) NSString*base64Bookmark;
@property (retain, atomic) NSURL*securityScopeURL;

+ (TrackPhoto*) trackPhotoWithFilepath:(NSString*)filepath;

- (id) initWithFilepath:(NSString*)filepath;

- (ISODate*) timeOfPhoto;
- (void) setTimeOfPhoto:(ISODate*)newValue;

- (NSImage*) image;
- (NSString*) filepath;
- (NSString*) iCloudFilepath;
- (NSString*) originalFilepath;
- (NSURL*) iCloudURL;
- (NSURL*) iCloudThumbnailURL;
- (void) deleteFromiCloud;
- (NSString*) filepathWithoutContainer;
- (void) setFilepath:(NSString*)newValue;

- (void) createGPXForParent:(NSXMLElement*)parent configuration:(
        GpxExportConfiguration*)cfg;

+ (BOOL) interpolateForDate:(ISODate*)actualIsoDate
    previousTrackPoint:(
        TrackPoint*)previousTrackPoint nextTrackPoint:(TrackPoint*)nextTrackPoint
    longitude:(double*)longitude latitude:(
        double*)latitude elevation:(double*)
    elevation;

- (TrackPoint*) trackPoint;
- (void) setTrackPoint:(TrackPoint*)newValue;

- (void) updateExifForGPSLocation:(BOOL)gpsLocation locationInformation:(BOOL)
    locationInformation addKeywords:(BOOL)addKeywords timeStamps:(BOOL)timeStamps;
- (void) updateExifForGPSLocation:(BOOL)gpsLocation locationInformation:(BOOL)
    locationInformation addKeywords:(BOOL)addKeywords timeStamps:(BOOL)timeStamps
    filepath:(NSString*)filepath withActionlist:(BOOL)
    withActionlist latitude:(
        double)latitude longitude:(double)longitude elevation:(double)elevation;
- (void) updateExifForGPSLocation:(BOOL)gpsLocation locationInformation:(BOOL)
    locationInformation addKeywords:(BOOL)addKeywords timeStamps:(BOOL)timeStamps
    filepath:(NSString*)filepath withActionlist:(BOOL)
    withActionlist;
- (void) updateExifForGPSLocation:(BOOL)gpsLocation locationInformation:(BOOL)
    locationInformation addKeywords:(BOOL)addKeywords timeStamps:(BOOL)timeStamps
    latitude:(double)latitude longitude:(double)longitude
    elevation:(double)
    elevation;

- (void) loadTimeOfPhotoFromFile;

- (NSString*) city;
- (void) setCity:(NSString*)newValue;
- (NSString*) state;
- (void) setState:(NSString*)newValue;
- (NSString*) country;
- (void) setCountry:(NSString*)newValue;
- (NSString*) isoCountryCode;
- (NSString*) isoCountryCodeWith3Chars;
- (void) setIsoCountryCode:(NSString*)newValue;
- (NSString*) place;
- (void) setPlace:(NSString*)newValue;

- (BOOL) hasLocationData;

- (void) setLocationInformationFromExif;
- (BOOL) checkExistenceOfPhotos;
- (BOOL) imageSizeWidth:(int*)width height:(int*)height;
- (void) unloadImage;
- (BOOL) updatePathFromBookmark;
- (void) updateBookmarkFromPath;

- (void) createKMLPlacemarkForParent:(NSXMLElement*)parent filename:(NSString*)
    filename maxWidth:(int)maxWidth maxHeight:(int)maxHeight
    scaledFile:(NSString*)
    scaledFile configuration:(TrackKMLConfiguration*)configuration;

- (BOOL) createJPG:(NSString*)filename width:(int*)width height:(int*)height
    quality:(float)quality;

@end
