//
//  TrackLibraryXML.h
//  myTracks
//
//  Created by Dirk Stichling on 28.01.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class TrackLibrary;
@class TrackLibraryFolder;

@interface TrackLibraryXML : NSObject <NSXMLParserDelegate>
{
    NSMutableArray* _stackOfFolders;
    BOOL _isStandardLibrary;
}

@property (assign, atomic) BOOL isStandardLibrary;

+ (TrackLibraryXML*) trackLibraryXML;

- (void)             export:(NSString*)pathToFile;
- (void) export:(NSString*)pathToFile forFolder:(TrackLibraryFolder*)folder;
- (void) import:(NSString*)pathToFile;
- (void) import:(NSString*)pathToFile toFolder:(TrackLibraryFolder*)folder;

@end
