//
//  TrackLibraryFolder.h
//  myTracks
//
//  Created by Dirk Stichling on 29.03.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

#import <DsTrackFramework/GpxImportConfiguration.h>
#import <DsTrackFramework/NamedAndTimedObject.h>
#import <DsTrackFramework/PointInTrack.h>

@class Track;
@class TrackLibrary;

@interface TrackLibraryFolder : NamedAndTimedObject {
    NSMutableArray* _tracks;
    NSMutableArray* _folders;
    TrackLibraryFolder* _parent;
    BOOL _isSelected;
    BOOL _doNotSaveInStandardLibrary;
    BOOL _excludeFromTimeLine;

    BOOL _needsUpdate;
    BOOL _needsFolderSorting;
    
    double _length;
    int _photoCount;
    int _waypointCount;
    NSTimeInterval _durationReal;
}

@property (assign, atomic) BOOL doNotSaveInStandardLibrary;

+ (TrackLibraryFolder*) trackLibraryFolder;
- (id) init;

- (BOOL) isSelected;
- (void) setIsSelected:(BOOL)newValue;

- (BOOL) excludeFromTimeLine;
- (void) setExcludeFromTimeLine:(BOOL)value;

- (NSMutableArray*) tracks;
- (NSMutableArray*) folders;

- (void) addTrack:(Track*)track;
- (void) addTrack:(Track*)track afterTrack:(Track*)otherTrack;
- (void) addTrack:(Track*)track name:(NSString*)name filename:(NSString*)filename;
- (Track*) addTrack:(NSString*)name fromiCloudFile:(NSString*)filename;

- (void) deleteTrack:(Track*)track;
- (void) deleteTrack:(Track*)track deleteCloudPhotos:(BOOL)deleteCloudPhotos;

- (void) addFolder:(TrackLibraryFolder*)folder;
- (void) addFolderAtBeginning:(TrackLibraryFolder*)folder;
- (TrackLibraryFolder*) getFolder:(NSString*)folderName;
- (TrackLibraryFolder*) getOrCreateFolderPath:(NSArray*)folderNames;
- (void) deleteFolder:(TrackLibraryFolder*)folder;

- (TrackLibraryFolder*) parent;
- (void) setParent:(TrackLibraryFolder*)newValue;

- (void) splitAtPointInTrack:(PointInTrack)pointInTrack;
- (void) splitAtPointInTrack:(PointInTrack)firstPointInTrack secondPointInTrack:(PointInTrack)secondPointInTrack;
- (void) splitAtTrackPoint:(TrackPoint*)trackPoint;

#if 0
- (int) importGPX:(NSString*)pathToFile setTimeZone:(BOOL)setTimeZone;
- (int) importGPX:(NSString*)pathToFile setTimeZone:(BOOL)setTimeZone delegate:(id)delegate;
- (int) importGPX:(NSString*)pathToFile setTimeZone:(BOOL)setTimeZone delegate:(id)delegate removeAllWaypoints:(BOOL)removeAllWaypoints;
#else
- (int) importGPX:(NSString*)pathToFile configuration:(GpxImportConfiguration*)cfg;
- (int) importPnts:(NSString*)filename;
#endif /* if 0 */

- (Track*) firstSelectedTrack;

- (void) addAllTracksToArray:(NSMutableArray*)array;
- (void) addAllSelectedTracksToArray:(NSMutableArray*)array;
- (void) addtrackPhotosOfTracks:(NSMutableArray*)array;
- (void) addtrackPhotosOfSelectedFolders:(NSMutableArray*)array;
- (void) addAllSelectedFoldersToArray:(NSMutableArray*)array;

- (NSMutableArray*) allTracks;
- (NSMutableArray*) allSelectedTracks;
- (NSMutableArray*) allSelectedFolders;
- (NSArray*) trackPhotosOfTracks;
- (NSArray*) trackPhotosOfSelectedFolders;

- (int) indexOfTrack:(Track*)track;
- (int) indexOfTrackLibraryFolder:(TrackLibraryFolder*)trackLibraryFolder;
- (void) addPath:(NSMutableString*)path;
- (NSString*) path;

- (void) moveTrackLibraryFolderHere:(TrackLibraryFolder*)trackLibraryFolder;
- (void) moveTrackHere:(Track*)track;

- (NSComparisonResult) compareName:(TrackLibraryFolder*)otherObject;
- (NSComparisonResult) compareNameDescending:(TrackLibraryFolder*)otherObject;

- (void) sortByNameAscending:(BOOL)ascending;
- (void) sortByDateAndNameAscending:(BOOL)ascending;
- (void) sortByDateAscending:(BOOL)ascending;
- (void) sortByLengthAscending:(BOOL)ascending;
- (void) sortByDurationAscending:(BOOL)ascending;
- (void) sortBydurationRealAscending:(BOOL)ascending;

- (void) selectAllTracks;
- (void) unselectAll;

- (Track*) trackWithTrackId:(NSString*)trackId;

- (void) setMetadataDirtyOfAllTracks:(BOOL)value;

- (int) importKML:(NSString*)pathToFile;
- (int) importKML:(NSString*)pathToFile setTimeZone:(BOOL)setTimeZone delegate:(id)delegate;
- (int) importLOC:(NSString*)pathToFile;
- (int) importLOC:(NSString*)pathToFile setTimeZone:(BOOL)setTimeZone delegate:(id)delegate;
- (int) import:(NSString*)pathToFile format:(NSString*)format;
- (int) import:(NSString*)pathToFile format:(NSString*)format gpxConfiguration:(GpxImportConfiguration*)importConfiguration;

- (double) length;
- (int) photoCount;
- (int) waypointCount;

- (void) updateProperties;
- (void) updatePropertiesToRootFolder;

- (double) durationReal;
- (NSString*) durationRealString;

- (void) deleteEmptySubfolders;

@end
