//
//  LocationPool.h
//  myTracks
//
//  Created by Dirk Stichling on 15.07.09.
//  Copyright 2009 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@protocol GISServiceConvertLocation;
@class Track;

@interface LocationPoolElement : NSObject
{
    NSString* key;

    double longitude;
    double latitude;

    NSString* name;
    NSString* countryName;
    NSString* countryCode;
    NSString* placeName;
    NSString* stateName;

    BOOL dirty;
    BOOL dataAvailable;
}

@property (assign, atomic) double longitude;
@property (assign, atomic) double latitude;
@property (retain, atomic, setter = setName :) NSString* name;
@property (retain, atomic, setter = setCountryName :) NSString* countryName;
@property (retain, atomic, setter = setCountryCode :) NSString* countryCode;
@property (retain, atomic, setter = setPlaceName :) NSString* placeName;
@property (retain, atomic, setter = setStateName :) NSString* stateName;
@property (readonly, atomic) BOOL dataAvailable;
@property (readonly, atomic) NSString* key;

- (void)      store;

- (NSString*) description;

@end


@interface LocationPool : NSObject {
    IBOutlet id updateTarget1;
    IBOutlet id updateTarget2;

    NSMutableArray* pendingElements;
    NSMutableDictionary* availableElements;

    NSCondition* newElementsToLoad;

    id<GISServiceConvertLocation> gisService;

    id notificationTarget;
    SEL notificationSelector;
}

@property (retain, nonatomic) id notificationTarget;
@property (assign, atomic) SEL notificationSelector;

+ (LocationPool*)        singleton;

- (LocationPoolElement*) elementForLongitude:(double)longitudeArg latitude:(double)latitudeArg;
- (void) updateForTrack:(Track*)track;

@end
