//
//  GPSBabel.h
//  myTracks
//
//  Created by Dirk Stichling on 12.03.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@interface GPSBabel : NSObject {
    NSString* _device;
    NSString* _deviceType;
    NSString* _additionalCommandlineOptions;

    NSMutableArray* _fileFormats;
    NSMutableDictionary* _fileNameToDescription;
    NSMutableDictionary* _fileDescriptionToName;

    NSMutableDictionary* _internalDrivers;
}

/*+ (GPSBabel*) gpsBabel*/;
+ (GPSBabel*) singleton;

+ (NSString*) correctSetting:(NSString*)setting;

- (id) init;

- (int) importTracksAndWaypointToFile:(NSString*)file;
- (int) deleteTracksAndWaypointToFile:(NSString*)file;
- (int) importTracksAndWaypointFromFile:(NSString*)inputFile toFile:(NSString*)outputFile errorString:(NSMutableString*)errorString;
- (int) convertToTrackFromFile:(NSString*)inputFile toFile:(NSString*)outputFile errorString:(NSMutableString*)errorString;

- (NSString*) device;
- (void) setDevice:(NSString*)newValue;

- (NSString*) deviceType;
- (void) setDeviceType:(NSString*)newValue;

- (NSString*) additionalCommandlineOptions;
- (void) setAdditionalCommandlineOptions:(NSString*)newValue;

- (NSString*) getRealtimeTrackingString;
- (int) convertGPX:(NSString*)gpxFilename toKML:(NSString*)kmlFilename;
- (int) convertKML:(NSString*)kmlFilename toGPX:(NSString*)gpxFilename;
- (int) convertLOC:(NSString*)locFilename toGPX:(NSString*)gpxFilename;
- (int) convertGPI:(NSString*)gpiFilename toGPX:(NSString*)gpxFilename;
- (int) convert:(NSString*)gpiFilename toGPX:(NSString*)gpxFilename format:(NSString*)format;
- (int) simplifyFile:(NSString*)inFilename toFile:(NSString*)outFilename count:(int)count;

- (void) killAllRunningProcesses;

- (NSArray*) fileFormats;
- (NSDictionary*) fileNameToDescription;
- (NSDictionary*) fileDescriptionToName;

- (NSString*) getDescriptionForFileFormat:(NSString*)fileFormat;

@end
