//
//  ExifTool.h
//  myTracks
//
//  Created by Dirk Stichling on 21.07.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class ISODate;

@interface ExifTool : NSObject {
}

+ (NSString*) exifToolPath;
+ (NSDictionary*) exifTagsForFile:(NSString*)filename;
+ (NSDictionary*) exifTagsForFileAndXmp:(NSString*)filename;

+ (double) latitudeFromDictionary:(NSDictionary*)dictionary;
+ (double) longitudeFromDictionary:(NSDictionary*)dictionary;
+ (double) elevationFromDictionary:(NSDictionary*)dictionary;
+ (int) rotationFromDictionary:(NSDictionary*)dictionary;
+ (NSString*) cityFromDictionary:(NSDictionary*)dictionary;
+ (NSString*) countryFromDictionary:(NSDictionary*)dictionary;
+ (NSString*) stateFromDictionary:(NSDictionary*)dictionary;
+ (NSString*) locationFromDictionary:(NSDictionary*)dictionary;
+ (NSString*) isoCountryCodeFromDictionary:(NSDictionary*)dictionary;

+ (ISODate*) digitizedFromDictionary:(NSDictionary*)dictionary defaultOffsetInMinutes:(int)defaultOffsetInMinutes forceTimezone:(BOOL)forceTimezone;
+ (ISODate*) isoDateForFile:(NSString*)filename defaultOffsetInMinutes:(int)defaultOffsetInMinutes forceTimezone:(BOOL)forceTimezone;

+ (void) copyTagsFrom:(NSString*)srcFilename to:(NSString*)destFilename;

+ (BOOL) isPhotoExtension:(NSString*)filename;
+ (BOOL) canWriteToFile:(NSString*)filename;

@end
