//
//  PluginMapLayer.h
//  DsMapFramework
//
//  Created by Dirk Stichling on 19.03.11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import <DsMapFramework/MapLayer.h>
#import <DsUtilities/DsUtilities.h>

@interface PluginMapLayer : MapLayer {
    NSArray* cacheURLs;
    NSArray* hiresCacheURLs;
    NSString* cacheTemplate;
    NSString* originalFilename;

    NSInteger indexCounter;
    BOOL initialized;
    BOOL isOfflineMap;
}

@property (readonly, atomic) BOOL initialized;

+ (BOOL) writePluginXml:(NSString*)filename name:(NSString*)name cacheFolder:(NSString*)cacheFolder hiresCacheFolder:(NSString*)hiresCacheFolder copyrightText:(NSString*)copyrightText maxZoomLevel:(NSInteger)maxZoomLevel cacheURLs:(NSArray*)cacheURLs hiresCacheURLs:(NSArray*)hiresCacheURLs cacheTemplate:(NSString*)cacheTemplate;

+ (BOOL) writePluginXml:(NSString*)filename name:(NSString*)name cacheFolder:(NSString*)cacheFolder template:(PluginMapLayer*)template;

- (id) initWithPluginFile:(NSString*)filename;
- (NSString*) cacheTemplate;
- (NSArray*) cacheURLs;
- (NSArray*) hiresCacheURLs;
- (BOOL) isOfflineMap;
- (NSString*) originalFilename;

@end
