//
//  MapViewPath.h
//  myTracks
//
//  Created by Dirk Stichling on 28.01.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@interface MapViewPath : NSObject {
//	NSMutableArray*		_segments;
    NSPoint* _points;
    int _numberOfPoints;
    int _maxPoints;
    NSColor* _color;
    BOOL _showArea;
    float _areaDistanceInPixel;
    int _lineWidth;
}

@property (assign, atomic) BOOL showArea;
@property (assign, atomic) float areaDistanceInPixel;
@property (retain, nonatomic) NSColor* color;
@property (readonly, atomic) int maxPoints;
@property (assign, atomic) int lineWidth;

+ (MapViewPath*) mapViewPathWithMaxNumberOfPoints:(int)maxPoints;
- (id) initWithMaxNumberOfPoints:(int)maxPoints;
- (void) dealloc;

+ (MapViewPath*) mapViewPathWithAttributesOfMapViewPath:(MapViewPath*)otherMapViewPath;

- (void) addPoint:(NSPoint)point;
- (int) points:(NSPoint**)points;

@end
