//
//  MapLayer.h
//  myTracks
//
//  Created by Dirk Stichling on 05.11.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>
#import <WebKit/WebKit.h>

#import <DsMapFramework/MapStore.h>

@class WebScriptObject;

@interface MapLayer : NSObject {
    id<MapStore> _mapStore;
    NSString* _cacheFolder;
    NSString* _hiresCacheFolder;
    NSString* _name;

    SEL _selGetURLFromTile;
    id _targetGetURLFromTile;

    MapLayer* _baseMapLayer;
    NSString* _baseMapLayerName;

    NSString* _webMapType;
    NSString* _webMapProvider;

    NSInteger _minZoomLevel;
    NSInteger _maxZoomLevel;

    BOOL _isExternalMapLayer;
    BOOL _isMkMapLayer;

    NSString* _copyrightText;

    BOOL _useHires;
}

@property (retain, atomic) NSString* copyrightText;
@property (retain, atomic) MapLayer* baseMapLayer;
@property (retain, atomic) NSString* baseMapLayerName;
@property (assign, atomic) BOOL supportsDarkMode;

+ (MapLayer*) mapLayer;

+ (MapLayer*) mapLayerWithWebMapType:(NSString*)webMapType name:(NSString*)name;

+ (MapLayer*) mapLayerWithGetURLFromTileSelector:(SEL)selector
    selectorTarget:(id)target
    cacheFolder:(NSString*)cacheFolder
    name:(NSString*)name;

+ (MapLayer*) externalMapLayerWithGetURLFromTileSelector:(SEL)selector
    selectorTarget:(id)target
    name:(NSString*)name;

- (id) initWithWebMapType:(NSString*)webMapType name:(NSString*)name;

- (id) initWithGetURLFromTileSelector:(SEL)selector
    selectorTarget:(id)target
    cacheFolder:(NSString*)cacheFolder
    name:(NSString*)name;

- (id) initWithGetURLFromTileSelector:(SEL)selector
    selectorTarget:(id)target
    name:(NSString*)name;

- (NSString*) currentCacheFolder;
- (void) setCacheFolder:(NSString*)newValue;
- (void) setHiresCacheFolder:(NSString*)newValue;

- (id<MapStore>) mapStore;
- (NSString*) name;
- (void) setName:(NSString*)name;

- (void) setGetURLFromTileSelector:(SEL)selector target:(id)target;

- (NSURL*) getURLFromTileX:(int)tileX tileY:(int)tileY zoomLevel:(int)zoomLevel;

- (NSString*) webMapType;

- (NSInteger) minZoomLevel;
- (void) setMinZoomLevel:(NSInteger)newValue;
- (NSInteger) maxZoomLevel;
- (void) setMaxZoomLevel:(NSInteger)newValue;

// WebViews
- (NSString*) htmlPageWithLatitude:(float)latitude longitude:(float)longitude zoomLevel:(int)zoomLevel width:(int)width height:(int)height;
- (void) updateLatitude:(float)latitude longitude:(float)longitude zoomLevel:(int)zoomLevel windowScriptObject:(WebScriptObject*)win;
- (void) updateWidth:(int)width height:(int)height windowScriptObject:(WebScriptObject*)win;
- (void) updateMapType:(NSString*)mapType windowScriptObject:(WebScriptObject*)win;

- (NSString*) webMapProvider;
- (void) setWebMapProvider:(NSString*)newValue;

- (BOOL) isExternalMapLayer;
- (BOOL) isMkMapLayer;

- (NSString*) licenseAgreementUrl;
- (BOOL) allowsGpsTracking;

- (BOOL) supportsHires;
- (void) useHires:(BOOL)value;

@end
