//
//  MTArrowView.h
//  myPhotoMap
//
//  Created by Dirk Stichling on 25.02.12.
//  Copyright (c) 2012 Dirk Stichling. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class AnnotationStyle;

@interface MTArrowView : NSImageView {
    NSString*        arrowId;
    id               delegate;
    double           scale;

    AnnotationStyle* annotationStyle;
}

@property (retain, nonatomic) NSString*     arrowId;
@property (retain, nonatomic) id            delegate;
@property (assign, atomic) double           scale;
@property (retain, atomic) AnnotationStyle* annotationStyle;

- (id)   initWithArrowId:(NSString*)arrowId;
- (void) moveFrom:(NSPoint)from to:(NSPoint)to maxSize:(double)maxSize;

@end
