//
//  WorkflowHelpController.h
//  myTracks
//
//  Created by Dirk Stichling on 31.08.09.
//  Copyright 2009 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@interface WorkflowHelpController : NSObject <WorkflowHelp> {
    IBOutlet NSPanel* panel;
    IBOutlet NSTextView* textView;
    IBOutlet NSButton* additionalButton;
    IBOutlet NSButton* doNotShowAgainButton;

    SEL _buttonSelector;
    id _buttonSelectorTarget;
    SEL _closeSelector;
    id _closeSelectorTarget;
    NSString* _doNotShowAgainPreferenceString;
}

+ (WorkflowHelpController*) singleton;

- (IBAction)                close:(id)sender;
- (IBAction) buttonClicked:(id)sender;

- (void) showRTFD:(NSString*)rtfd title:(NSString*)title size:(NSSize)size buttonTitle:(NSString*)buttonTitle buttonSelector:(SEL)buttonSelector buttonSelectorTarget:(id)buttonSelectorTarget doNotShowAgainPreferenceString:(NSString*)doNotShowAgainPreferenceString;
- (void) showRTFD:(NSString*)rtfd title:(NSString*)title size:(NSSize)size buttonTitle:(NSString*)buttonTitle buttonSelector:(SEL)buttonSelector buttonSelectorTarget:(id)buttonSelectorTarget;
- (void) showRTFD:(NSString*)rtfd title:(NSString*)title size:(NSSize)size;
- (void) showRTFD:(NSString*)rtfd title:(NSString*)title size:(NSSize)size doNotShowAgainPreferenceString:(NSString*)doNotShowAgainPreferenceString;

- (void) setCloseSelector:(SEL)closeSelector closeSelectorTarget:(id)closeSelectorTarget;

@end
