//
//  Controllers.h
//  DsControllers
//
//  Created by Dirk Stichling on 07.01.2013.
//  Copyright (c) 2013 Dirk Stichling. All rights reserved.
//

#import <DsMapFramework/DsMapFramework.h>
#import <DsTrackFramework/DsTrackFramework.h>
#import <Foundation/Foundation.h>

@protocol MapControllerProto

- (void) updateView;
- (void) moveToLatitude:(double)latitude longitude:(double)longitude;

- (void) getLowerLeftLatitude:(double*)latitude longitude:(double*)longitude;
- (void) getUpperRightLatitude:(double*)latitude longitude:(double*)longitude;

- (NSImage*) flagLogoSmall;
- (MapViewPin*) searchPin;

- (int) zoomLevel;
- (double) centerLatitude;
- (double) centerLongitude;

@end

@protocol TrackSelectionControllerProto

- (void) setSelectedPointInTrack:(PointInTrack)selectedPointInTrack;
- (void) setSelectedPointInTrack:(PointInTrack)selectedPointInTrack withEndPoint:(PointInTrack)selectedEndPointInTrack;
- (void) setSelectedEndPointInTrack:(PointInTrack)selectedEndPointInTrack;
- (PointInTrack) selectedPointInTrack;
- (PointInTrack) selectedEndPointInTrack;

- (Track*) selectedTrack;
- (TrackPoint*) selectedTrackPoint;
- (TrackPoint*) selectedEndTrackPoint;

- (void) resetSelectedPoint;

@end

@protocol MainControllerProto

- (void) importGPXForFiles:(NSArray*)files;
- (NSWindow*) myTracksMainWindow;
- (BOOL) performDragOperation:(id<NSDraggingInfo>)sender;
- (BOOL) performDragOperation:(id<NSDraggingInfo>)sender pasteboard:(NSPasteboard*)pboard;

@end

@interface Controllers : NSObject

+ (id<MapControllerProto>) mapController;
+ (void) setMapController:(id<MapControllerProto>)value;

+ (id<TrackSelectionControllerProto>) trackSelectionController;
+ (void) setTrackSelectionController:(id<TrackSelectionControllerProto>)value;

+ (id<MainControllerProto>) mainController;
+ (void) setMainController:(id<MainControllerProto>)value;

@end
