//
//  MyTraceEnabled.h
//  myTracks4iPhoneOS
//
//  Created by Dirk Stichling on 13.01.15.
//  Copyright (c) 2015 Dirk Stichling. All rights reserved.
//

#import <Foundation/Foundation.h>

#ifdef ENABLE_TRACE
#define MyLog(...) [MyTrace log:__FILE__ function:__FUNCTION__ line:__LINE__ userLog:NO withFormat:__VA_ARGS__]
#else
#define MyLog(...)
#endif

#define MyLogForce(...) [MyTrace log:__FILE__ function:__FUNCTION__ line:__LINE__ userLog:NO withFormat:__VA_ARGS__]
#define MyLogUser(...) [MyTrace log:__FILE__ function:__FUNCTION__ line:__LINE__ userLog:YES withFormat:__VA_ARGS__]

@interface MyTrace : NSObject

+ (BOOL) logUserData;
+ (void) setLogUserData:(BOOL)value;

+ (void) log:(const char*)file function:(const char*)function line:(NSInteger)line userLog:(BOOL)userLog withFormat:(NSString*)format, ...;

@end
