//
//  MTImage.h
//  myTracks
//
//  Created by Dirk Stichling on 06.06.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/MyCocoa.h>


@interface MTImage : NSObject {
    CGImageRef _image;
    NSDictionary*          _meta;
    NSRect _bounds;
    NSColor*                                _backgroundColor;
    NSString*                               _filepath;
    NSURL*                                  _securityScopedURL;
    BOOL _scaleProportionally;
    BOOL _topRight;

    BOOL _previewAvailable;

    BOOL _doNotUseThumbnail;
}

@property (assign, atomic) BOOL doNotUseThumbnail;

- (void) setFilepath:(NSString*)path;
- (void) setSecurityScopedURL:(NSURL*)securityScopedURL;
- (void) setImage:(CGImageRef)image withMetadata:(NSDictionary*)meta;
- (void) draw:(NSRect)bounds;
- (void) draw:(NSRect)bounds withBackground:(BOOL)withBackground;
- (void) directDraw:(NSRect)bounds;

- (NSColor*) backgroundColor;
- (void) setBackgroundColor:(NSColor*)newValue;

- (NSSize) size;
- (int) orientation;

- (void) setScaleProportionally:(BOOL)scaleProportionally;
- (void) setTopRight:(BOOL)topRight;

@end
