//
//  CloudElementSync.h
//  DsUtilities
//
//  Created by Dirk Stichling on 23.11.13.
//  Copyright (c) 2013 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/CloudElementSyncDelegate.h>
#import <Foundation/Foundation.h>

@interface CloudElementSync : NSObject <NSFilePresenter> {
    id<CloudElementSyncDelegate> delegate;
    NSURL* cloudURL;
    NSMetadataQuery* query;
    NSOperationQueue* operationQueue;
    NSMutableSet* elementsInCloud;
    NSString* name;

    NSMutableDictionary* elements;
}

@property (retain, nonatomic) id<CloudElementSyncDelegate> delegate;

+ (CloudElementSync*) cloudElementSyncWithCoudUrl:(NSURL*)url name:(NSString*)serviceName;

- (id) initWithCoudUrl:(NSURL*)url name:(NSString*)serviceName;

- (NSString*) cloudURL;

- (NSString*) addElement:(NSData*)element;
- (void) updateElement:(NSString*)guid withData:(id)data;
- (void) deleteElement:(NSString*)guid;
- (void) deleteAll;

- (NSData*) getDataForElement:(NSString*)guid;

@end
