#import <DsUtilities/DsUtilities.h>

#import <DsTrackFramework/GpxExportConfiguration.h>

@class TrackPhoto;
@class Track;
@class TrackKMLConfiguration;

@protocol GISServiceConvertLocation;

@interface TrackPointLink : NSObject
{
    NSString* type;
    NSString* url;
}

@property (retain, atomic) NSString* type;
@property (retain, atomic) NSString* url;

@end

@interface TrackPoint : NSObject
{
    ISODate* _time;
    double _latitude;
    double _longitude;
    double _elevation;
    double _speed;
    double _length;
    double _lengthFromStart;
    BOOL _isEndOfSegment;
    NSString* _wayPointID;
    Track* _parent;

    NSMutableArray* _trackPhotos;

    NSString* _name;
    NSString* _description;
    NSString* _tags;
    NSString* _comment;
    NSString* _symbol;
    NSString* _color;
}

@property (retain, atomic) NSString* name;
@property (retain, atomic) NSString* description;
@property (retain, atomic) NSString* tags;
@property (retain, atomic) NSString* comment;
@property (retain, atomic) NSString* wayPointID;
@property (retain, atomic) NSString* symbol;
@property (retain, atomic) NSString* color;

@property (assign, atomic) double length;
@property (assign, atomic) double lengthFromStart;

@property (assign, atomic) BOOL isEndOfSegment;
@property (readonly, atomic) BOOL isLast;

+ (TrackPoint*) trackPointWithParent:(Track*)parent;
+ (TrackPoint*) trackPointWithParent:(Track*)parent point:(TrackPoint*)point;
- (id) initWithParent:(Track*)parent;

- (Track*) track;

- (void) setTime:(ISODate*)time;
- (ISODate*) time;

- (void) setIsWayPoint:(BOOL)isWayPoint;
- (BOOL) isWayPoint;

- (void) setLatitude:(double)latitude;
- (void) setLongitude:(double)longitude;
- (void) setElevation:(double)elevation;
- (void) setSpeed:(double)speed;

- (double) latitude;
- (double) longitude;
- (double) elevation;
- (double) speed;

- (void) makeDirty;

- (double) relativeDistanceToLatitude:(double)latitude longitude:(double)longitude;
+ (double) distanceFromLatitude:(double)lat1 longitude:(double)lon1 ToLatitude:(double)lat2 longitude:(double)lon2;
- (double) distanceToTrackPoint:(TrackPoint*)otherPoint;
- (double) distanceToLatitude:(double)lat2 longitude:(double)lon2;

- (void) moveLatitude:(double)latitude longitude:(double)longitude;

- (void) createGPXForParent:(NSXMLElement*)parent waypointsOnly:(BOOL)waypointsOnly configuration:(GpxExportConfiguration*)cfg;

- (void) createKMLPlacemarkForParent:(NSXMLElement*)parent configuration:(TrackKMLConfiguration*)configuration;

- (void) copyWaypointAttributesFrom:(TrackPoint*)waypoint;
- (void) copyTextualAttributesFrom:(TrackPoint*)waypoint;
- (void) removeAllWaypointData;

// Photos
- (NSMutableArray*) trackPhotos;
- (BOOL) hasPhotos;
- (void) addTrackPhoto:(TrackPhoto*)trackPhoto;
- (void) addTrackPhoto:(TrackPhoto*)trackPhoto sorted:(BOOL)sorted;
- (void) removeTrackPhoto:(TrackPhoto*)trackPhoto;
- (TrackPhoto*) getFirstPhoto;
- (void) removePhotoReferences;
- (void) importPhotos:(NSArray*)files;
- (void) updateExifForGPSLocation:(BOOL)gpsLocation locationInformation:(BOOL)locationInformation addKeywords:(BOOL)addKeywords timeStamps:(BOOL)timeStamps;
- (BOOL) updateAddressInformationWithService:(id<GISServiceConvertLocation>)service;
- (void) addTrackPhotos:(NSMutableArray*)array;

- (NSDictionary<NSString*,NSString*>*) toPoiDict;
+ (TrackPoint*) fromPoiDict:(NSDictionary<NSString*,id>*)dict;

@end
