//
//  TrackGPX.h
//  myTracks
//
//  Created by Dirk Stichling on 28.01.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>
#import <DsTrackFramework/GpxExportConfiguration.h>

@class Track;

@interface TrackGPX : NSObject <NSXMLParserDelegate>
{
    Track* _track;
    NSMutableArray* _wayPoints;
    NSString* _importFilename;
}

+ (TrackGPX*) trackGPXWithTrack:(Track*)track;
- (id) initWithTrack:(Track*)track;

- (Track*)    track;

// GPX Import
- (void) import:(NSString*)pathToFile;

// GPX Export
- (void) export:(NSString*)pathToFile configuration:(GpxExportConfiguration*)cfg;
- (void) export:(NSString*)pathToFile tracks:(NSArray*)tracks configuration:(GpxExportConfiguration*)cfg;

- (NSString*) importFilename;

@end
