#import <DsUtilities/DsUtilities.h>

#import <DsTrackFramework/NamedObject.h>

@class ISODate;

@interface NamedAndTimedObject : NamedObject
{
    ISODate*       _startTime;
    ISODate*       _endTime;
    NSTimeInterval _duration;
    NSString*      _runtimeID;
}

@property (readonly) NSString* runtimeID;

+ (NSString*) getDurationStringFrom:(ISODate*)start to:(ISODate*)end;

+ (NamedAndTimedObject*) namedAndTimedObject;
- (id)                   init;

+ (NamedAndTimedObject*) namedAndTimedObjectWithName:(NSString*)name;
- (id) initWithName:(NSString*)name;

- (void) setStartTime:(ISODate*)startTime;
- (ISODate*)             startTime;

- (void) setEndTime:(ISODate*)endTime;
- (ISODate*)             endTime;

- (void) setDuration:(NSTimeInterval)duration;
- (NSTimeInterval)       duration;
- (NSString*)            durationString;
- (void)                 updateDuration;

- (NSComparisonResult) compareName:(NamedAndTimedObject*)otherObject;
- (NSComparisonResult) compareNameDescending:(NamedAndTimedObject*)otherObject;
- (NSComparisonResult) compareDate:(NamedAndTimedObject*)otherObject;
- (NSComparisonResult) compareDateDescending:(NamedAndTimedObject*)otherObject;
- (BOOL) belongsToObjectAtDate:(ISODate*)dateOfOtherObject;

@end
