//
//  GpxImportConfiguration.h
//  myTracks21
//
//  Created by Dirk Stichling on 19.04.10.
//  Copyright 2010 Dirk Stichling. All rights reserved.
//

#import <Foundation/Foundation.h>

@class TrackLibraryFolder;
@class Track;

@interface GpxImportConfiguration : NSObject {
    BOOL setTimeZone;
    id delegate;
    BOOL removeAllWaypoints;
    NSString* trackIdPrefix;
    NSMutableArray* importedTracks;
    NSMutableArray* importedPOIs;
    TrackLibraryFolder* targetFolder;
    BOOL doNotImportPOIs;
    NSString* filename;
    NSInteger newTrackCounter;
    NSInteger identicalTrackCounter;
    BOOL correctWeekRollover;
}

@property (assign, atomic) BOOL setTimeZone;
@property (assign, atomic) id delegate;
@property (assign, atomic) BOOL removeAllWaypoints;
@property (retain, nonatomic) NSString* trackIdPrefix;
@property (readonly, atomic) NSMutableArray* importedTracks;
@property (retain, atomic) NSMutableArray* importedPOIs;
@property (retain, nonatomic) TrackLibraryFolder* targetFolder;
@property (assign, atomic) BOOL doNotImportPOIs;
@property (retain, atomic) NSString* filename;
@property (assign, atomic) NSInteger newTrackCounter;
@property (assign, atomic) NSInteger identicalTrackCounter;
@property (assign, atomic) BOOL correctWeekRollover;
@property (assign, atomic) BOOL importWaypointID;
@property (retain, nonatomic) Track* waypointTrack;

+ (GpxImportConfiguration*) gpxImportConfiguration;

@end
