//
//  GNS2000.h
//  DsTrackFramework
//
//  Created by Dirk Stichling on 23.08.13.
//  Copyright (c) 2013 Dirk Stichling. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <IOBluetooth/IOBluetooth.h>

#import <DsTrackFramework/GpsDriver.h>

@class Track;

#define kGNS2000ProtocolVersionInfo 1
#define kGNS2000ProtocolFinished    2
#define kGNS2000ProtocolFailure     3
#define kGNS2000ProtocolStartData   4
#define kGNS2000ProtocolReadData    5
#define kGNS2000ProtocolStartErase  6

@interface GNS2000 : NSObject <GpsDriver, IOBluetoothRFCOMMChannelDelegate> {
    IOBluetoothDevice* bluetoothDevice;
    IOBluetoothRFCOMMChannel* rfcommChannel;

    Track* currentTrack;
    NSMutableArray* tracks;
    NSInteger protocolCommand;
    NSInteger pmtkloxCount;
    NSInteger pmtkloxPacketCounter;
    NSInteger nonPResponseCounter;
    NSInteger previousTimestamp;
    BOOL createNewTrack;

    NSMutableData* receivedData;
    BOOL firstResponseReceived;

    NSCondition* stopCondition;
}

@end
