//
//  MapViewPoint.h
//  myTracks
//
//  Created by Dirk Stichling on 05.02.08.
//  Copyright 2008 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@class MTAnnotationView;
@class AnnotationStyle;

typedef enum
{
    MapViewPointCircleNo,
    MapViewPointCircleBlue,
    MapViewPointCircleRed
} MapViewPointCircleMode;

@interface MapViewPoint : NSObject {
    NSPoint                _point;
    NSColor*               _color;
    NSImage*               _image;
    NSImage*               _multiImageOverlay;

    NSInteger              _offsetX;
    NSInteger              _offsetY;
    float                  _contentsScale;

    NSInteger              _annotationOffsetX;
    NSInteger              _annotationOffsetY;

    NSInteger              _useCounter;
    BOOL                   _mergePoints;
    NSInteger              _visibleElementsIfMultiPoint;

    NSString*              _text;

    NSString*              _annotationId;
    int                    _annotationHeight;

    MapViewPointCircleMode _circleMode;
    int                    _circleRadius;

    id                     _userData;

    NSString*              _photoFilename;
    int                    _photoHeight;

    BOOL                   _showAnnotationArrow;

    AnnotationStyle*       _annotationStyle;
}

@property (assign, atomic) NSInteger              useCounter;
@property (assign, atomic) BOOL                   mergePoints;
@property (assign, atomic) NSInteger              visibleElementsIfMultiPoint;
@property (retain, nonatomic) NSString*           text;
@property (retain, nonatomic) NSString*           annotationId;
@property (assign, atomic) MapViewPointCircleMode circleMode;
@property (assign, atomic) int                    circleRadius;
@property (assign, atomic) int                    annotationHeight;
@property (assign, atomic) id                     userData;
@property (assign, atomic) NSInteger              offsetX;
@property (assign, atomic) NSInteger              offsetY;
@property (assign, atomic) NSInteger              annotationOffsetX;
@property (assign, atomic) NSInteger              annotationOffsetY;
@property (retain, atomic) NSString*              photoFilename;
@property (assign, atomic) int                    photoHeight;
@property (assign, atomic) BOOL                   showAnnotationArrow;
@property (retain, nonatomic) AnnotationStyle*    annotationStyle;
@property (assign, atomic) BOOL                   isDraggeable;

+ (MapViewPoint*) mapViewPoint;
- (id)            init;

- (void)          setPoint:(NSPoint)point;
- (NSPoint)       point;

- (void)          setContentsScale:(float)value;
- (float)         contentsScale;

- (void)          setColor:(NSColor*)color;
- (NSColor*)      color;

- (void)          setImage:(NSImage*)image;
- (NSImage*)      image;

- (void)          setMultiImageOverlay:(NSImage*)image;
- (NSImage*)      multiImageOverlay;


@end
