//
//  ExternalMapStore.h
//  myTracks
//
//  Created by Dirk Stichling on 25.05.09.
//  Copyright 2009 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>
#import <DsMapFramework/MapStore.h>

@interface ExternalMapStore : NSObject <MapStore> {
    MapLayer* _mapLayer;
    MapView*  _mapView;
}

+ (ExternalMapStore*) mapStore;
- (id)                init;

- (NSImage*)          getImageForTileX:(int)tileX tileY:(int)tileY zoomLevel:(int)zoomLevel load:(BOOL)load forceLoad:(BOOL)forceLoad;
- (NSImage*)          getImageForTileX:(int)tileX tileY:(int)tileY zoomLevel:(int)zoomLevel;
- (MapLayer*)         mapLayer;
- (void)              setMapLayer:(MapLayer*)newValue;
- (void)              resetDictOfImages;
- (void)              setMapView:(MapView*)mapView;

@end
