//
//  AnnotationStyle.h
//  myPhotoMap
//
//  Created by Dirk Stichling on 25.02.12.
//  Copyright (c) 2012 Dirk Stichling. All rights reserved.
//

#import <DsUtilities/DsUtilities.h>

@interface AnnotationStyle : NSObject {
    NSString* name;
    NSString* guid;
    NSString* backgroundSlimImageFilename;
    NSString* backgroundHighImageFilename;
    NSString* arrowImageFilename;
    NSColor*  textColor;
    NSString* fontName;
    double    arrowSize;
    double    additionalBorder;

    NSImage*  backgroundSlimImage;
    NSImage*  backgroundHighImage;
    NSImage*  arrowImage;

    BOOL      isCustom;
}

@property (retain, nonatomic) NSString* name;
@property (retain, nonatomic) NSString* guid;
@property (retain, nonatomic) NSString* backgroundSlimImageFilename;
@property (retain, nonatomic) NSString* backgroundHighImageFilename;
@property (retain, nonatomic) NSString* arrowImageFilename;
@property (retain, nonatomic) NSColor*  textColor;
@property (retain, nonatomic) NSString* fontName;
@property (assign, atomic) double       arrowSize;
@property (assign, atomic) double       additionalBorder;
@property (assign, atomic) BOOL         isCustom;

+ (AnnotationStyle*) getStyleByGUID:(NSString*)guid;
+ (NSArray*)         allStyles;
+ (AnnotationStyle*) defaultStyle;

- (NSImage*)         backgroundSlimImage;
- (NSImage*)         backgroundHighImage;
- (NSImage*)         arrowImage;

+ (NSArray*)         customStyles;

+ (void)             storeCustomStyles;
- (BOOL)             importExternalImage:(NSString*)externalImage withExtension:(NSString*)extension;
- (BOOL)             importImage:(NSImage*)image withExtension:(NSString*)extension;

- (void)             useAsDefaultStyle;
- (void)             delete;

@end
